clc; clear; 

%% Problem Data
n = 2;

Q = [0.3   -0.7
    -0.7    2.0];

c  = [-1; .1];

x0 = [-0.8; 1];
  
% number of polygon sides
n_poly = 5;
% Ax = b, defines the polygon interior
A = zeros(n_poly,2);
b = zeros(n_poly,1);

% define polygon (n_poly points around a circle)
theta_poly = (0:(2*pi)/n_poly:2*pi);
x_poly = cos(theta_poly);
y_poly = 1.5*sin(theta_poly-pi/10);% rotate the y coord

% segments of circle define the polygon
for i = 1:n_poly

    % compute direction p = x2-x1
    p = [x_poly(i+1)-x_poly(i)
         y_poly(i+1)-y_poly(i)];

    % get the normal direction
    % rotate 90 degrees counter-clockwise
    a = [p(2),-p(1)];
    a = a/norm(a);

    A(i,:) = a;

    % offset of the polygon side
    b(i) = a*[x_poly(i); y_poly(i)];

end



%% Algorithm

options = optimoptions('quadprog','Algorithm','active-set','OptimalityTolerance',1e-8,'Display','off');
x_qp = quadprog(Q,c,A,b,[],[],[],[],x0,options);

% Projected grad descent
[x_newt,data,niter] = newton_method(@(x)(objective(x,Q,c)),Q,c,A,b,x0);

fprintf('Solution\n  QuadProg     PGD\n')
disp([x_qp,x_newt])

%% Plotting

% Plot the QP
figure(1),clf, hold on, box on
plotregion(-A,-b,[],[],[0.8,0.8,0.8]); % plot the feasible region
obj = @(x,y) [x;y]'*Q*[x;y] + c'*[x;y];
fcontour(obj,'--','LineWidth',2)

% Plot the iterates and search directions

for i= 1:(niter-1)
    plot(data.x(1,i),data.x(2,i),'ko','MarkerFaceColor','k')
    quiver(data.x(1,i),data.x(2,i),data.x(1,i+1)-data.x(1,i),data.x(2,i+1)-data.x(2,i),0)
    pause(0.5)
end

plot(x_qp(1),x_qp(2),"pentagram",'MarkerSize',10,'MarkerFaceColor','b')



